﻿Option Strict On
Option Explicit On
Option Infer Off

Public Class Form1

    Dim dragDropSource As Object = Nothing

    Public Sub New()

        InitializeComponent()

        'Wypełnianie list
        For i As Integer = 1 To 10
            ListBox1.Items.Add("lista 1, pozycja " & i.ToString())
            ListBox2.Items.Add("lista 2, pozycja " & i.ToString())
            ListBox3.Items.Add("lista 3, pozycja " & i.ToString())
        Next
    End Sub

    Private Sub ListBox1_MouseDown(sender As System.Object, e As System.Windows.Forms.MouseEventArgs) Handles ListBox1.MouseDown, ListBox3.MouseDown, ListBox2.MouseDown
        Dim lbSender As ListBox = CType(sender, ListBox)
        Dim indeks As Integer = lbSender.IndexFromPoint(e.X, e.Y)
        dragDropSource = sender 'przechowanie referencji dla DragOver

        If e.Button = MouseButtons.Left And indeks <> -1 Then
            Dim operacja As DragDropEffects =
                lbSender.DoDragDrop(lbSender.Items(indeks), DragDropEffects.Copy Or DragDropEffects.Move)
            If operacja = DragDropEffects.Move Then lbSender.Items.RemoveAt(indeks)
        End If

        dragDropSource = Nothing
    End Sub

    Private Sub ListBox1_DragOver(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles ListBox1.DragOver, ListBox3.DragOver, ListBox2.DragOver
        If sender Is dragDropSource Then
            e.Effect = DragDropEffects.None
        ElseIf (e.KeyState And 8) = 8 Then
            e.Effect = DragDropEffects.Copy 'z CTRL
        Else
            e.Effect = DragDropEffects.Move
        End If
    End Sub

    Private Sub ListBox1_DragDrop(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles ListBox1.DragDrop, ListBox3.DragDrop, ListBox2.DragDrop
        Dim lbSender As ListBox = CType(sender, ListBox)
        Dim indeks As Integer = lbSender.IndexFromPoint(lbSender.PointToClient(New Point(e.X, e.Y)))
        If indeks = -1 Then indeks = lbSender.Items.Count
        lbSender.Items.Insert(indeks, e.Data.GetData(DataFormats.Text).ToString())
    End Sub
End Class
